-- Tabele z pliku GrafikUczelniStrukturaPG.sql muszą zostać utworzone najpierw.

SET search_path TO GrafikUczelniPrzyklad;

CREATE VIEW R04_lista_budynkow
AS
SELECT   NazwaBudynku, LiczbaKondygnacji
FROM         Budynki
ORDER BY NazwaBudynku;


CREATE VIEW R04_informacja_o_zajeciach
AS
SELECT Zajecia.*
FROM Zajecia ;


CREATE VIEW R04_tytuly_naukowe
AS
SELECT DISTINCT Tytul
FROM Wykladowcy ;


CREATE VIEW R04_lista_pracownikow_z_telefonami
AS
SELECT   NazwiskoPracownika, ImiePracownika, TelefonPracownika
FROM         Pracownicy
ORDER BY NazwiskoPracownika, ImiePracownika;


CREATE VIEW R04_lista_przedmiotow
AS
SELECT Przedmioty.NazwaPrzedmiotu
FROM Przedmioty ;


CREATE VIEW R05_lata_pracy
AS
SELECT  Concat(NazwiskoPracownika, ', ', ImiePracownika) AS Pracownik, DataZatrudnienia,
   TRUNC(((CAST('2017-10-1' As Date) - DataZatrudnienia) / 365), 0)
                      AS StazWSzkole
FROM         Pracownicy
ORDER BY Pracownik;


CREATE VIEW R05_proponowane_premie
AS
SELECT   Concat(NazwiskoPracownika, ', ', ImiePracownika) AS Pracownicy, Wynagrodzenie, Wynagrodzenie * 0.07 AS Premia
FROM         Pracownicy
ORDER BY Pracownicy;



CREATE VIEW R05_lista_pracownikow_wedlug_wynagrodzenia
AS
SELECT   Wynagrodzenie, Concat(NazwiskoPracownika, ', ', ImiePracownika) AS CzlonekPersonelu
FROM         Pracownicy
ORDER BY Wynagrodzenie DESC, CzlonekPersonelu;


CREATE VIEW R05_pracownicy_i_telefony
AS
SELECT   Concat(NazwiskoPracownika, ', ', ImiePracownika) AS CzlonekPersonelu, 
    Concat('(', NumKierPracownika, ') ', TelefonPracownika) AS Telefon
FROM         Pracownicy
ORDER BY CzlonekPersonelu;


CREATE VIEW R05_studenci_wedlug_miasta
AS
SELECT   MiastoStudenta, Concat(NazwiskoStudenta, ', ', ImieStudenta) AS Student
FROM         Studenci
ORDER BY MiastoStudenta, Student;


CREATE VIEW R06_adiunkci_na_pelnym_etacie
AS
SELECT Wykladowcy.IDPracownika, Wykladowcy.Tytul, Wykladowcy.Status
FROM Wykladowcy
WHERE (((Wykladowcy.Tytul)='Adiunkt') AND ((Wykladowcy.Status)='Pełny wymiar'));


CREATE VIEW R06_studenci_z_Seattle_i_o_nazwisku_Kennedy
AS
SELECT ImieStudenta, NazwiskoStudenta, MiastoStudenta
FROM Studenci
WHERE NazwiskoStudenta = 'Kennedy' OR MiastoStudenta = 'Seattle' ;


CREATE VIEW R06_wynagrodzenie_pracownikow_40tys_do_50tys
AS
SELECT   ImiePracownika, NazwiskoPracownika, Wynagrodzenie
FROM         Pracownicy
WHERE     (Wynagrodzenie BETWEEN 40000 AND 50000)
ORDER BY NazwiskoPracownika, ImiePracownika;


CREATE VIEW R06_pracownicy_uzywajacy_skrytek_pocztowych
AS
SELECT   ImiePracownika, NazwiskoPracownika, AdresPracownika
FROM         Pracownicy
WHERE     (AdresPracownika LIKE '%Box%')
ORDER BY ImiePracownika, NazwiskoPracownika;


CREATE VIEW R06_studenci_spoza_Idaho_i_Waszyngtonu
AS
SELECT Concat(NazwiskoStudenta, ', ', ImieStudenta) AS PersonaliaStudenta, 
     NumKierStudenta, TelefonStudenta, StanZamStudenta
FROM Studenci
WHERE StanZamStudenta NOT IN ('ID', 'OR', 'WA') ;


CREATE VIEW R06_przedmioty_z_MUZ_w_kodzie_przedmiotu
AS
SELECT NazwaPrzedmiotu, OpisPrzedmiotu, KodPrzedmiotu
FROM Przedmioty
WHERE KodPrzedmiotu LIKE 'MUZ%';


CREATE VIEW R08_budynki_i_sale
AS
SELECT Budynki.NazwaBudynku, Sale.IDSali
FROM Budynki INNER JOIN Sale 
  ON (Budynki.KodBudynku = Sale.KodBudynku);


CREATE VIEW R08_studenci_z_wysokimi_ocenami_z_informatyki_i_sztuki
AS
SELECT     StudArt.PersonaliaStudenta
FROM  (SELECT DISTINCT Studenci.IDStudenta, 
         Concat(Studenci.NazwiskoStudenta, ', ', Studenci.ImieStudenta) AS PersonaliaStudenta
       FROM (((Studenci 
                INNER JOIN Grafik_studenta 
                ON Studenci.IDStudenta = Grafik_studenta.IDStudenta) 
                INNER JOIN Zajecia 
                ON Zajecia.IDZajec = Grafik_studenta.IDZajec) 
                INNER JOIN Przedmioty 
                ON Przedmioty.IDPrzedmiotu = Zajecia.IDPrzedmiotu) 
                INNER JOIN Dziedziny 
                ON Dziedziny.IDDziedziny = Przedmioty.IDDziedziny
       WHERE      Dziedziny.OpisDziedziny = 'Sztuka' 
                         AND Grafik_studenta.Ocena >= 85) StudArt 
    INNER JOIN
      (SELECT DISTINCT Grafik_studenta.IDStudenta
       FROM          ((Grafik_studenta 
                INNER JOIN Zajecia 
                ON Zajecia.IDZajec = Grafik_studenta.IDZajec) 
                INNER JOIN Przedmioty 
                ON Przedmioty.IDPrzedmiotu = Zajecia.IDPrzedmiotu) 
                INNER JOIN Dziedziny 
                ON Dziedziny.IDDziedziny = Przedmioty.IDDziedziny
       WHERE      Dziedziny.OpisDziedziny LIKE '%Systemy%' 
                         AND Grafik_studenta.Ocena >= 85) StudCS 
    ON StudArt.IDStudenta = StudCS.IDStudenta;


CREATE VIEW R08_przedmioty_wykladowcow
AS
SELECT Concat(Pracownicy.NazwiskoPracownika, ', ', Pracownicy.ImiePracownika) AS PersonaliaWykladowcy, Przedmioty.NazwaPrzedmiotu
FROM (Pracownicy INNER JOIN Przedmioty_wykladowcow 
  ON (Pracownicy.IDPracownika = Przedmioty_wykladowcow.IDPracownika)) 
INNER JOIN Przedmioty 
  ON (Przedmioty.IDPrzedmiotu = Przedmioty_wykladowcow.IDPrzedmiotu);


CREATE VIEW R08_zapisy_studentow
AS
SELECT Concat(Studenci.NazwiskoStudenta, ', ', Studenci.ImieStudenta) AS PersonaliaStudenta, 
     Zajecia.IDZajec, Przedmioty.NazwaPrzedmiotu
FROM (((Studenci INNER JOIN Grafik_studenta 
  ON (Studenci.IDStudenta = Grafik_studenta.IDStudenta)) 
INNER JOIN Status_zajec_studenta 
  ON (Grafik_studenta.StatusZajec = Status_zajec_studenta.StatusZajec)) 
INNER JOIN Zajecia 
  ON (Zajecia.IDZajec = Grafik_studenta.IDZajec)) 
INNER JOIN Przedmioty 
  ON (Przedmioty.IDPrzedmiotu = Zajecia.IDPrzedmiotu)
WHERE Status_zajec_studenta.OpisStatusuZajec = 'Zapisany' ;


CREATE VIEW R08_studenci_i_pracownicy_o_tym_samym_imieniu
AS
SELECT Concat(Studenci.ImieStudenta, ' ', Studenci.NazwiskoStudenta) AS PersonaliaStudenta, 
    Concat(Pracownicy.ImiePracownika, ' ', Pracownicy.NazwiskoPracownika) AS PersonaliaWykladowcy
FROM Studenci INNER JOIN Pracownicy 
  ON (Studenci.ImieStudenta = Pracownicy.ImiePracownika);


CREATE VIEW R08_przedmioty_na_srodowych_zajeciach
AS
SELECT DISTINCT Przedmioty.NazwaPrzedmiotu
FROM Przedmioty INNER JOIN Zajecia 
  ON (Przedmioty.IDPrzedmiotu = Zajecia.IDPrzedmiotu)
WHERE Zajecia.PlanNaSrode = 1;


CREATE VIEW R09_wszystkie_dziedziny_wszystkie_przedmioty_dowolne_zajecia
AS
SELECT Dziedziny.OpisDziedziny, Przedmioty.NazwaPrzedmiotu, Zajecia.IDSali, 
   Zajecia.DataRozpoczecia, Zajecia.GodzinaRozpoczecia, Zajecia.CzasTrwania
FROM (Dziedziny LEFT JOIN Przedmioty 
  ON Dziedziny.IDDziedziny = Przedmioty.IDDziedziny) 
LEFT JOIN Zajecia 
  ON Przedmioty.IDPrzedmiotu = Zajecia.IDPrzedmiotu;


CREATE VIEW R09_wszyscy_wykladowcy_dowolne_zajecia
AS
SELECT   Concat(Pracownicy.NazwiskoPracownika, ', ', Pracownicy.ImiePracownika) AS Pracownik, 
   Sched.NazwaPrzedmiotu, Sched.IDZajec, Sched.IDSali, Sched.GodzinaRozpoczecia, Sched.CzasTrwania
FROM Pracownicy LEFT OUTER JOIN
    (SELECT Zajecia_wykladowcow.IDPracownika, Przedmioty.NazwaPrzedmiotu, Zajecia.IDZajec, 
          Zajecia.IDSali, Zajecia.GodzinaRozpoczecia, Zajecia.CzasTrwania
     FROM Przedmioty INNER JOIN (Zajecia 
        INNER JOIN Zajecia_wykladowcow 
          ON Zajecia.IDZajec = Zajecia_wykladowcow.IDZajec) 
          ON Przedmioty.IDPrzedmiotu = Zajecia.IDPrzedmiotu) Sched 
  ON  Pracownicy.IDPracownika = Sched.IDPracownika;


CREATE VIEW R09_zajecia_bez_zapisanych_studentow
AS
SELECT Przedmioty.NazwaPrzedmiotu, Zajecia.IDSali, Zajecia.GodzinaRozpoczecia, Zajecia.CzasTrwania
FROM Przedmioty INNER JOIN Zajecia 
  ON Przedmioty.IDPrzedmiotu = Zajecia.IDPrzedmiotu
LEFT OUTER JOIN
   (SELECT Grafik_studenta.IDZajec
    FROM Status_zajec_studenta INNER JOIN Grafik_studenta 
      ON Status_zajec_studenta.StatusZajec = Grafik_studenta.StatusZajec
    WHERE Status_zajec_studenta.OpisStatusuZajec = 'Zapisany') Zapisany 
  ON Zajecia.IDZajec = Zapisany.IDZajec 
WHERE     (Zapisany.IDZajec IS NULL);


CREATE VIEW R09_wykladowcy_ktorzy_nie_prowadza_zajec
AS
SELECT Pracownicy.ImiePracownika, Pracownicy.NazwiskoPracownika
FROM Pracownicy LEFT JOIN Zajecia_wykladowcow 
  ON (Pracownicy.IDPracownika = Zajecia_wykladowcow.IDPracownika)
WHERE Zajecia_wykladowcow.IDZajec Is Null ;


CREATE VIEW R09_studenci_ktorzy_nigdy_nie_zrezygnowali_z_zajec
AS
SELECT Concat(Studenci.NazwiskoStudenta, ', ', Studenci.ImieStudenta) AS PersonaliaStudenta
FROM Studenci LEFT OUTER JOIN
     (SELECT Grafik_studenta.IDStudenta
      FROM Status_zajec_studenta INNER JOIN Grafik_studenta 
        ON Status_zajec_studenta.StatusZajec = Grafik_studenta.StatusZajec
      WHERE Status_zajec_studenta.OpisStatusuZajec = 'Rezygnacja') Rezygnacja 
  ON Studenci.IDStudenta = Rezygnacja.IDStudenta
WHERE (Rezygnacja.IDStudenta IS NULL);


CREATE VIEW R09_studenci_aktualnie_nie_zapisani_na_zajecia
AS
SELECT Studenci.IDStudenta, Studenci.ImieStudenta, Studenci.NazwiskoStudenta
FROM Studenci LEFT OUTER JOIN
     (SELECT IDStudenta, IDZajec, StatusZajec
      FROM Grafik_studenta
      WHERE StatusZajec = 1) Sched 
  ON Studenci.IDStudenta = Sched.IDStudenta
WHERE (Sched.IDStudenta IS NULL);


CREATE VIEW R09_przedmioty_bez_wykladowcy
AS
SELECT Przedmioty.IDPrzedmiotu, Przedmioty.KodPrzedmiotu, Przedmioty.NazwaPrzedmiotu
FROM Przedmioty LEFT JOIN Przedmioty_wykladowcow 
  ON (Przedmioty.IDPrzedmiotu = Przedmioty_wykladowcow.IDPrzedmiotu)
WHERE Przedmioty_wykladowcow.IDPracownika Is Null ;


CREATE VIEW R10_studenci_i_wykladowcy_z_dobrymi_wynikami_w_sztuce
AS
SELECT Studenci.ImieStudenta AS Imie, Studenci.NazwiskoStudenta AS Nazwisko, 
    Grafik_studenta.Ocena AS Ocena, 'Student' AS Typ
FROM (((Studenci INNER JOIN Grafik_studenta 
  ON (Studenci.IDStudenta = Grafik_studenta.IDStudenta)) 
INNER JOIN Status_zajec_studenta 
  ON (Status_zajec_studenta.StatusZajec = Grafik_studenta.StatusZajec)) 
INNER JOIN Zajecia 
  ON (Zajecia.IDZajec = Grafik_studenta.IDZajec)) 
INNER JOIN Przedmioty 
  ON (Przedmioty.IDPrzedmiotu = Zajecia.IDPrzedmiotu)
WHERE     Status_zajec_studenta.OpisStatusuZajec = 'Ukończono' 
     AND Grafik_studenta.Ocena >= 85 AND Przedmioty.IDDziedziny = 'SZT'
UNION
SELECT Pracownicy.ImiePracownika, Pracownicy.NazwiskoPracownika, 
   Przedmioty_wykladowcow.OcenaBieglosci AS Ocena, 'Wykladowcy' AS Typ
FROM (Pracownicy INNER JOIN Przedmioty_wykladowcow 
  ON (Pracownicy.IDPracownika = Przedmioty_wykladowcow.IDPracownika)) 
INNER JOIN Przedmioty 
  ON (Przedmioty.IDPrzedmiotu = Przedmioty_wykladowcow.IDPrzedmiotu)
WHERE Przedmioty_wykladowcow.OcenaBieglosci > 8 AND Przedmioty.IDDziedziny = 'SZT';


CREATE VIEW R10_studenci_i_pracownicy_lista_mailingowa
AS
SELECT  Concat(Studenci.ImieStudenta, ' ', Studenci.NazwiskoStudenta) AS Personalia, 
       Studenci.AdresStudenta, Studenci.MiastoStudenta, 
       Studenci.StanZamStudenta, Studenci.KodPocztowyStudenta
FROM Studenci
UNION
SELECT Concat(Pracownicy.ImiePracownika, ' ', Pracownicy.NazwiskoPracownika) AS Personalia, 
         Pracownicy.AdresPracownika, Pracownicy.MiastoPracownika, Pracownicy.StanZamPracownika, 
         Pracownicy.KodPocztowyPracownika
FROM Pracownicy
ORDER BY 5;


CREATE VIEW R11_liczba_zajec_wykladowcow
AS
SELECT Pracownicy.IDPracownika, Pracownicy.ImiePracownika, Pracownicy.NazwiskoPracownika, 
   (SELECT count(*) 
    FROM Zajecia_wykladowcow 
    WHERE Zajecia_wykladowcow.IDPracownika = Pracownicy.IDPracownika) AS LiczbaZajec
FROM Pracownicy;


CREATE VIEW R11_studenci_na_wtorkowych_zajeciach
AS
SELECT IDStudenta, ImieStudenta, NazwiskoStudenta
FROM Studenci
WHERE (IDStudenta IN
         (SELECT IDStudenta
          FROM Grafik_studenta INNER JOIN Zajecia 
            ON Grafik_studenta.IDZajec = Zajecia.IDZajec
          WHERE Zajecia.PlanNaWtorek = 1));


CREATE VIEW R11_studenci_ktorzy_nigdy_nie_zrezygnowali
AS
SELECT IDStudenta, ImieStudenta, NazwiskoStudenta
FROM Studenci
WHERE (IDStudenta NOT IN
         (SELECT Grafik_studenta.IDStudenta
          FROM Grafik_studenta INNER JOIN Status_zajec_studenta 
            ON Grafik_studenta.StatusZajec = Status_zajec_studenta.StatusZajec
          WHERE Status_zajec_studenta.OpisStatusuZajec = 'Rezygnacja'));


CREATE VIEW R11_przedmioty_i_liczba_poniedzialkowych_zajec
AS
SELECT Przedmioty.NazwaPrzedmiotu, 
   (SELECT count(*) 
    FROM Zajecia 
    WHERE PlanNaPoniedzialek = 1 AND Zajecia.IDPrzedmiotu = Przedmioty.IDPrzedmiotu) AS LiczbaZajWPon
FROM Przedmioty;


CREATE VIEW R11_przedmioty_z_ktorych_zajecia_odbywaja_sie_w_srody
AS
SELECT Dziedziny.OpisDziedziny, Przedmioty.IDPrzedmiotu, Przedmioty.KodPrzedmiotu, Przedmioty.NazwaPrzedmiotu
FROM Dziedziny INNER JOIN Przedmioty 
  ON (Dziedziny.IDDziedziny = Przedmioty.IDDziedziny)
WHERE Przedmioty.IDPrzedmiotu IN 
   (SELECT IDPrzedmiotu 
    FROM Zajecia 
    WHERE Zajecia.PlanNaSrode = 1) ;


CREATE VIEW R12_srednia_dlugosc_zajec
AS
SELECT avg(CzasTrwania) AS SredniaDlugoscZajec
FROM Zajecia;


CREATE VIEW R12_najwyzsza_placa_pracownika
AS
SELECT max(Wynagrodzenie) AS NajwyzszaPlaca
FROM Pracownicy;


CREATE VIEW R12_najstarsi_stazem_pracownicy
AS
SELECT Concat(NazwiskoPracownika, ', ', ImiePracownika) AS CzlonekPersonelu
FROM Pracownicy
WHERE DataZatrudnienia = 
   (SELECT min(DataZatrudnienia) FROM Pracownicy) ;


CREATE VIEW R12_liczba_zajec_odbywajacych_sie_w_sali_numer_3346
AS
SELECT count(*) AS LacznaLiczbaZajec
FROM Zajecia
WHERE IDSali = 3346;


CREATE VIEW R12_laczne_place_pracownikow_z_Kalifornii
AS
SELECT sum(Wynagrodzenie) AS LacznaPlaca
FROM Pracownicy
WHERE StanZamPracownika='CA';


CREATE VIEW R13_liczba_zajec_wedlug_dziedziny
AS
SELECT Dziedziny.OpisDziedziny, count(*) AS LiczbaZajec
FROM (Dziedziny INNER JOIN Przedmioty 
  ON (Dziedziny.IDDziedziny = Przedmioty.IDDziedziny)) 
INNER JOIN Zajecia 
  ON (Przedmioty.IDPrzedmiotu = Zajecia.IDPrzedmiotu)
GROUP BY Dziedziny.OpisDziedziny ;


CREATE VIEW R13_liczba_zajec_wedlug_wykladowcy
AS
SELECT Pracownicy.ImiePracownika, Pracownicy.NazwiskoPracownika, count(*) AS LiczbaZajec
FROM Pracownicy INNER JOIN Zajecia_wykladowcow 
  ON (Pracownicy.IDPracownika = Zajecia_wykladowcow.IDPracownika)
GROUP BY Pracownicy.ImiePracownika, Pracownicy.NazwiskoPracownika ;


CREATE VIEW R13_liczba_zajec_wedlug_wykladowcy_podzapytanie
AS
SELECT Pracownicy.IDPracownika, Pracownicy.ImiePracownika, Pracownicy.NazwiskoPracownika, 
   (SELECT count(*) 
    FROM Zajecia_wykladowcow 
    WHERE Zajecia_wykladowcow.IDPracownika = Pracownicy.IDPracownika) AS LiczbaZajec
FROM Pracownicy;


CREATE VIEW R13_srednia_ocena_studentow_wg_dziedziny
AS
SELECT Dziedziny.OpisDziedziny, Studenci.ImieStudenta, Studenci.NazwiskoStudenta, 
   avg(Grafik_studenta.Ocena) AS SredniaOcen
FROM ((((Dziedziny 
         INNER JOIN Przedmioty 
           ON (Dziedziny.IDDziedziny = Przedmioty.IDDziedziny)) 
         INNER JOIN Zajecia 
           ON (Przedmioty.IDPrzedmiotu = Zajecia.IDPrzedmiotu)) 
         INNER JOIN Grafik_studenta 
           ON (Zajecia.IDZajec = Grafik_studenta.IDZajec)) 
         INNER JOIN Status_zajec_studenta 
           ON (Status_zajec_studenta.StatusZajec = Grafik_studenta.StatusZajec)) 
         INNER JOIN Studenci 
           ON (Studenci.IDStudenta = Grafik_studenta.IDStudenta)
WHERE Status_zajec_studenta.OpisStatusuZajec = 'Ukończono'
GROUP BY Dziedziny.OpisDziedziny, Studenci.ImieStudenta, Studenci.NazwiskoStudenta ;


CREATE VIEW R14_studenci_na_piatke
AS
SELECT Dziedziny.OpisDziedziny, Studenci.ImieStudenta, Studenci.NazwiskoStudenta, 
   avg(Grafik_studenta.Ocena) AS SredniaOcen
FROM ((((Dziedziny 
         INNER JOIN Przedmioty 
           ON (Dziedziny.IDDziedziny = Przedmioty.IDDziedziny)) 
         INNER JOIN Zajecia 
           ON (Przedmioty.IDPrzedmiotu = Zajecia.IDPrzedmiotu)) 
         INNER JOIN Grafik_studenta 
           ON (Zajecia.IDZajec = Grafik_studenta.IDZajec)) 
         INNER JOIN Status_zajec_studenta 
           ON (Status_zajec_studenta.StatusZajec = Grafik_studenta.StatusZajec)) 
         INNER JOIN Studenci 
           ON (Studenci.IDStudenta = Grafik_studenta.IDStudenta)
WHERE Status_zajec_studenta.OpisStatusuZajec = 'Ukończono'
GROUP BY Dziedziny.OpisDziedziny, Studenci.ImieStudenta, Studenci.NazwiskoStudenta
HAVING avg(Grafik_studenta.Ocena) > 90 ;


CREATE VIEW R14_dziedziny_z_ktorych_odbywaja_sie_3_zajecia_lub_wiecej
AS
SELECT Dziedziny.OpisDziedziny, count(*) AS LiczbaZajec
FROM (Dziedziny INNER JOIN Przedmioty 
  ON (Dziedziny.IDDziedziny = Przedmioty.IDDziedziny)) 
INNER JOIN Zajecia 
  ON (Przedmioty.IDPrzedmiotu = Zajecia.IDPrzedmiotu)
GROUP BY Dziedziny.OpisDziedziny
HAVING count(*) > 3 ;


CREATE VIEW R14_liczba_profesorow_biologii
AS
SELECT count(Wykladowcy.IDPracownika) AS ProfBiologii
FROM (Wykladowcy INNER JOIN Dziedziny_wykladowcow 
  ON (Wykladowcy.IDPracownika = Dziedziny_wykladowcow.IDPracownika)) 
INNER JOIN Dziedziny 
  ON (Dziedziny.IDDziedziny = Dziedziny_wykladowcow.IDDziedziny)
WHERE Dziedziny.OpisDziedziny = 'Biologia' 
      AND Wykladowcy.Tytul = 'Profesor' ;


CREATE VIEW R14_wykladowcy_prowadzacy_od_1_do_3_zajec
AS
SELECT Pracownicy.ImiePracownika, Pracownicy.NazwiskoPracownika, count(*) AS LiczbaZajec
FROM Pracownicy INNER JOIN Zajecia_wykladowcow 
  ON (Pracownicy.IDPracownika = Zajecia_wykladowcow.IDPracownika)
GROUP BY Pracownicy.ImiePracownika, Pracownicy.NazwiskoPracownika
HAVING count(*) < 3;


CREATE VIEW R14_wykladowcy_liczba_zajec_grupowanie_DOBRZE
AS
SELECT Pracownicy.ImiePracownika, Pracownicy.NazwiskoPracownika, Count(Zajecia_wykladowcow.IDPracownika) AS LiczbaZajec
FROM Pracownicy LEFT JOIN Zajecia_wykladowcow 
  ON Pracownicy.IDPracownika=Zajecia_wykladowcow.IDPracownika
GROUP BY Pracownicy.ImiePracownika, Pracownicy.NazwiskoPracownika;


CREATE VIEW R14_wykladowcy_liczba_zajec_grupowanie_ZLE
AS 
SELECT Pracownicy.ImiePracownika, Pracownicy.NazwiskoPracownika, Count(*) AS LiczbaZajec
FROM Pracownicy
INNER JOIN Zajecia_wykladowcow
  ON Pracownicy.IDPracownika = Zajecia_wykladowcow.IDPracownika
GROUP BY Pracownicy.ImiePracownika, Pracownicy.NazwiskoPracownika;


CREATE VIEW R14_wykladowcy_liczba_zajec_podzapytanie
AS
SELECT Pracownicy.ImiePracownika, Pracownicy.NazwiskoPracownika, 
   (SELECT COUNT(*) FROM Zajecia_wykladowcow WHERE Zajecia_wykladowcow.IDPracownika = Pracownicy.IDPracownika) AS LiczbaZajec
FROM Pracownicy
ORDER BY ImiePracownika, NazwiskoPracownika;


CREATE VIEW R14_wykladowcy_prowadzacy_mniej_niz_3_zajecia
AS
SELECT Concat(NazwiskoPracownika, ', ', ImiePracownika) AS Pracownik,
   (SELECT     COUNT(S2.IDPracownika)
    FROM Pracownicy AS S2 INNER JOIN Zajecia_wykladowcow 
      ON S2.IDPracownika = Zajecia_wykladowcow.IDPracownika
    WHERE S2.IDPracownika = Pracownicy.IDPracownika) AS LiczbaWyklZaj
FROM Pracownicy
WHERE ((SELECT COUNT(S3.IDPracownika)
        FROM Pracownicy AS S3 INNER JOIN Zajecia_wykladowcow 
          ON S3.IDPracownika = Zajecia_wykladowcow.IDPracownika
        WHERE S3.IDPracownika = Pracownicy.IDPracownika) < 3);


CREATE VIEW R14_dziedziny_z_mniej_niz_3_profesorami_DOBRZE
AS
SELECT Dziedziny.OpisDziedziny, Count(FCP.IDPracownika) AS LiczbaProfesorow
FROM Dziedziny LEFT JOIN 
   (SELECT Dziedziny_wykladowcow.IDDziedziny, Dziedziny_wykladowcow.IDPracownika
    FROM Dziedziny_wykladowcow INNER JOIN Wykladowcy
      ON Dziedziny_wykladowcow.IDPracownika = Wykladowcy.IDPracownika
    WHERE Wykladowcy.Tytul='Profesor') AS FCP
  ON Dziedziny.IDDziedziny = FCP.IDDziedziny 
GROUP BY Dziedziny.OpisDziedziny
HAVING Count(FCP.IDPracownika) < 3;


CREATE VIEW R14_dziedziny_z_mniej_niz_3_profesorami_JOIN_DOBRZE
AS
SELECT OpisDziedziny,
       (SELECT     COUNT(Wykladowcy.IDPracownika)
        FROM (Wykladowcy INNER JOIN Dziedziny_wykladowcow 
          ON Wykladowcy.IDPracownika = Dziedziny_wykladowcow.IDPracownika) 
        INNER JOIN Dziedziny AS C2 
          ON C2.IDDziedziny = Dziedziny_wykladowcow.IDDziedziny
        WHERE C2.IDDziedziny = Dziedziny.IDDziedziny 
               AND Wykladowcy.Tytul = 'Profesor') AS LiczbaProfesorow
FROM Dziedziny
WHERE ((SELECT COUNT(Wykladowcy.IDPracownika)
        FROM (Wykladowcy INNER JOIN Dziedziny_wykladowcow 
          ON Wykladowcy.IDPracownika = Dziedziny_wykladowcow.IDPracownika) 
        INNER JOIN Dziedziny AS C3 
          ON C3.IDDziedziny = Dziedziny_wykladowcow.IDDziedziny
        WHERE C3.IDDziedziny = Dziedziny.IDDziedziny 
              AND Wykladowcy.Tytul = 'Profesor') < 3);


CREATE VIEW R14_dziedziny_z_mniej_niz_3_profesorami_ZLE
AS
SELECT Dziedziny.OpisDziedziny, Count(Dziedziny_wykladowcow.IDPracownika) AS LiczbaProfesorow
FROM (Dziedziny INNER JOIN Dziedziny_wykladowcow 
  ON (Dziedziny.IDDziedziny = Dziedziny_wykladowcow.IDDziedziny)) 
INNER JOIN Wykladowcy 
  ON (Wykladowcy.IDPracownika = Dziedziny_wykladowcow.IDPracownika)
WHERE Wykladowcy.Tytul='Profesor'
GROUP BY Dziedziny.OpisDziedziny
HAVING count(Dziedziny_wykladowcow.IDPracownika) < 3 ;


CREATE VIEW R18_zajecia_bez_zapisanych_studentow_NOT_IN
AS 
SELECT Przedmioty.NazwaPrzedmiotu, Zajecia.IDSali, Zajecia.GodzinaRozpoczecia, Zajecia.CzasTrwania
FROM Przedmioty INNER JOIN Zajecia
  ON Przedmioty.IDPrzedmiotu=Zajecia.IDPrzedmiotu
WHERE Zajecia.IDZajec NOT IN 
   (SELECT Grafik_studenta.IDZajec  
    FROM Grafik_studenta INNER JOIN Status_zajec_studenta
      ON Grafik_studenta.StatusZajec = Status_zajec_studenta.StatusZajec 
    WHERE Status_zajec_studenta.OpisStatusuZajec = 'Zapisany');


CREATE VIEW R18_studenci_dobrzy_w_sztuce_i_informatyce_EXISTS
AS 
SELECT Studenci.IDStudenta, Studenci.ImieStudenta, Studenci.NazwiskoStudenta
FROM Studenci
WHERE EXISTS 
  (SELECT Grafik_studenta.IDStudenta
   FROM ((Grafik_studenta INNER JOIN Zajecia
     ON Zajecia.IDZajec = Grafik_studenta.IDZajec)
   INNER JOIN Przedmioty
     ON Przedmioty.IDPrzedmiotu = Zajecia.IDPrzedmiotu)
   INNER JOIN Dziedziny
     ON Dziedziny.IDDziedziny = Przedmioty.IDDziedziny
   WHERE Dziedziny.OpisDziedziny = 'Sztuka'
          AND Grafik_studenta.Ocena >= 85
          AND Grafik_studenta.IDStudenta = Studenci.IDStudenta)
AND EXISTS 
   (SELECT Grafik_studenta.IDStudenta
    FROM ((Grafik_studenta INNER JOIN Zajecia
      ON Zajecia.IDZajec = Grafik_studenta.IDZajec)
    INNER JOIN Przedmioty
      ON Przedmioty.IDPrzedmiotu = Zajecia.IDPrzedmiotu)
    INNER JOIN Dziedziny
      ON Dziedziny.IDDziedziny = Przedmioty.IDDziedziny
    WHERE Dziedziny.OpisDziedziny LIKE  '%Systemy%'
           AND Grafik_studenta.Ocena >= 85
           AND Grafik_studenta.IDStudenta = Studenci.IDStudenta);


CREATE VIEW R18_studenci_dobrzy_w_sztuce_i_informatyce_IN
AS 
SELECT Studenci.IDStudenta, Studenci.ImieStudenta, Studenci.NazwiskoStudenta
FROM Studenci
WHERE Studenci.IDStudenta IN
   (SELECT Grafik_studenta.IDStudenta 
    FROM ((Grafik_studenta
    INNER JOIN Zajecia 
      ON Zajecia.IDZajec = Grafik_studenta.IDZajec) 
    INNER JOIN Przedmioty 
      ON Przedmioty.IDPrzedmiotu = Zajecia.IDPrzedmiotu) 
    INNER JOIN Dziedziny 
      ON Dziedziny.IDDziedziny = Przedmioty.IDDziedziny 
    WHERE Dziedziny.OpisDziedziny = 'Sztuka' 
           AND Grafik_studenta.Ocena >= 85) 
AND Studenci.IDStudenta IN 
   (SELECT Grafik_studenta.IDStudenta 
    FROM ((Grafik_studenta
    INNER JOIN Zajecia 
      ON Zajecia.IDZajec = Grafik_studenta.IDZajec) 
    INNER JOIN Przedmioty 
      ON Przedmioty.IDPrzedmiotu = Zajecia.IDPrzedmiotu) 
    INNER JOIN Dziedziny 
      ON Dziedziny.IDDziedziny = Przedmioty.IDDziedziny 
    WHERE Dziedziny.OpisDziedziny LIKE '%Systemy%' 
           AND Grafik_studenta.Ocena >= 85);


CREATE VIEW R18_wykladowcy_nie_prowadzacy_zajec_EXISTS
AS 
SELECT Pracownicy.ImiePracownika, Pracownicy.NazwiskoPracownika
FROM Pracownicy
WHERE NOT EXISTS
   (SELECT * FROM Zajecia_wykladowcow 
    WHERE Zajecia_wykladowcow.IDPracownika = Pracownicy.IDPracownika);


CREATE VIEW R18_wykladowcy_prowadzacy_zajecia_bez_akredytacji
AS 
SELECT Pracownicy.IDPracownika, Pracownicy.ImiePracownika, Pracownicy.NazwiskoPracownika, Zajecia.IDZajec, Zajecia.IDSali, 
   Zajecia.DataRozpoczecia, Zajecia.IDPrzedmiotu, Przedmioty.KodPrzedmiotu, Przedmioty.NazwaPrzedmiotu
FROM ((Zajecia INNER JOIN Zajecia_wykladowcow
  ON Zajecia.IDZajec = Zajecia_wykladowcow.IDZajec)
INNER JOIN Przedmioty
  ON Zajecia.IDPrzedmiotu = Przedmioty.IDPrzedmiotu)
INNER JOIN Pracownicy
  ON Pracownicy.IDPracownika=Zajecia_wykladowcow.IDPracownika
WHERE Zajecia.IDPrzedmiotu Not In 
   (SELECT IDPrzedmiotu FROM Przedmioty_wykladowcow WHERE IDPracownika = Pracownicy.IDPracownika);


CREATE VIEW R18_studenci_niespelniajacy_wymagan
AS 
SELECT Studenci.IDStudenta, Studenci.ImieStudenta, Studenci.NazwiskoStudenta, Zajecia.DataRozpoczecia, 
   Przedmioty.KodPrzedmiotu, Przedmioty.NazwaPrzedmiotu, Przedmioty.Wymagania
FROM ((Studenci INNER JOIN Grafik_studenta
  ON Studenci.IDStudenta = Grafik_studenta.IDStudenta)
INNER JOIN Zajecia
  ON Zajecia.IDZajec = Grafik_studenta.IDZajec)
INNER JOIN Przedmioty
  ON Przedmioty.IDPrzedmiotu = Zajecia.IDPrzedmiotu
WHERE Przedmioty.Wymagania Is Not Null  
AND Przedmioty.Wymagania NOT IN  
   (SELECT Przedmioty.KodPrzedmiotu  
    FROM ((Przedmioty INNER JOIN Zajecia As C2 
      ON Przedmioty.IDPrzedmiotu = C2.IDPrzedmiotu)  
    INNER JOIN Grafik_studenta  
      ON C2.IDZajec = Grafik_studenta.IDZajec)  
    INNER JOIN Status_zajec_studenta  
      ON Grafik_studenta.StatusZajec = Status_zajec_studenta.StatusZajec  
    WHERE Status_zajec_studenta.OpisStatusuZajec <> 'Rezygnacja'  
          AND Grafik_studenta.IDStudenta = Studenci.IDStudenta  
          AND C2.DataRozpoczecia <=  Zajecia.DataRozpoczecia);


CREATE VIEW R18_studenci_ktorzy_nigdy_nie_zrezygnowali_EXISTS
AS 
SELECT Concat(Studenci.NazwiskoStudenta, ', ', Studenci.ImieStudenta) AS PersonaliaStudenta
FROM Studenci
WHERE NOT EXISTS 
   (SELECT * 
    FROM Status_zajec_studenta INNER JOIN Grafik_studenta 
      ON Status_zajec_studenta.StatusZajec = Grafik_studenta.StatusZajec  
    WHERE Status_zajec_studenta.OpisStatusuZajec = 'Rezygnacja'
      AND Grafik_studenta.IDStudenta = Studenci.IDStudenta);


CREATE VIEW R18_studenci_aktualnie_nie_zapisani_na_zajecia_NOT_IN
AS 
SELECT Studenci.IDStudenta, Studenci.ImieStudenta, Studenci.NazwiskoStudenta
FROM Studenci
WHERE Studenci.IDStudenta NOT IN 
   (SELECT Grafik_studenta.IDStudenta 
    FROM Grafik_studenta INNER JOIN Status_zajec_studenta
      ON Grafik_studenta.StatusZajec = Status_zajec_studenta.StatusZajec
    WHERE Status_zajec_studenta.OpisStatusuZajec = 'Zapisany');


CREATE VIEW R18_studenci_ktorzy_zaliczyli_wszystko_na_80_plus
AS 
SELECT Studenci.IDStudenta, Studenci.ImieStudenta, Studenci.NazwiskoStudenta
FROM Studenci
INNER JOIN Grafik_studenta
  ON Studenci.IDStudenta=Grafik_studenta.IDStudenta
WHERE (Grafik_studenta.Ocena>80)
   AND (Grafik_studenta.StatusZajec=2)
GROUP BY Studenci.IDStudenta, Studenci.ImieStudenta, Studenci.NazwiskoStudenta
HAVING Count(Studenci.IDStudenta) =  
   (SELECT COUNT(*)  
    FROM Grafik_studenta  
    WHERE Grafik_studenta.StatusZajec = 2  
        AND Grafik_studenta.IDStudenta = Studenci.IDStudenta);


CREATE VIEW R18_przedmioty_bez_przydzielonego_wykladowcy_NOT_IN
AS 
SELECT Przedmioty.IDPrzedmiotu, Przedmioty.KodPrzedmiotu, Przedmioty.NazwaPrzedmiotu
FROM Przedmioty
WHERE Przedmioty.IDPrzedmiotu NOT IN
   (SELECT Przedmioty_wykladowcow.IDPrzedmiotu
    FROM Przedmioty_wykladowcow);


CREATE VIEW R19_podwyzki_dla_wykladowcow_w_pelnym_wymiarze_godzin
AS
SELECT Pracownicy.IDPracownika, Pracownicy.ImiePracownika, Pracownicy.NazwiskoPracownika, Wykladowcy.Tytul, 
    Wykladowcy.Status, Pracownicy.Wynagrodzenie, 
    (CASE Tytul 
       WHEN 'Instruktor' THEN ROUND(Wynagrodzenie * 1.05, 0) 
       WHEN 'Adiunkt' THEN ROUND(Wynagrodzenie * 1.04, 0) 
       WHEN 'Profesor' THEN ROUND(Wynagrodzenie * 1.035, 0) 
     ELSE Wynagrodzenie END) AS NoweWynagrodzenie
FROM Pracownicy INNER JOIN Wykladowcy 
  ON Pracownicy.IDPracownika = Wykladowcy.IDPracownika
WHERE (Wykladowcy.Status = 'Pełny wymiar');


CREATE VIEW R19_lata_pracy
AS
SELECT IDPracownika, ImiePracownika, NazwiskoPracownika, 
   EXTRACT(YEAR FROM CAST('2017-10-01' As Date)) - 
      EXTRACT(YEAR FROM DataZatrudnienia) - 
      (CASE WHEN EXTRACT(MONTH FROM DataZatrudnienia) < 10 
            THEN 0 
            WHEN EXTRACT(MONTH FROM DataZatrudnienia) > 10 
            THEN 1 
            WHEN EXTRACT(DAY FROM DataZatrudnienia) > 1 
            THEN 1 
            ELSE 0 END) AS StazPracy
FROM Pracownicy
ORDER BY NazwiskoPracownika, ImiePracownika;


CREATE VIEW R19_studenci_plci_meskiej
AS
SELECT IDStudenta, ImieStudenta, NazwiskoStudenta, 'Mezczyzna' AS Plec
FROM Studenci
WHERE ('Mezczyzna' = 
   (CASE PlecStudenta 
    WHEN 'M' THEN 'Mezczyzna' 
    ELSE 'Nomatch' END));


CREATE VIEW R19_wiek_studentow_na_15listopada2017
AS
SELECT IDStudenta, ImieStudenta, NazwiskoStudenta, DataUrodzStudenta, 
   EXTRACT(YEAR FROM CAST('2017-11-15' As Date)) - 
      EXTRACT(YEAR FROM DataUrodzStudenta) - 
      (CASE WHEN EXTRACT(MONTH FROM DataUrodzStudenta) < 11 
            THEN 0 
            WHEN EXTRACT(MONTH FROM DataUrodzStudenta) > 11 
            THEN 1 
            WHEN EXTRACT(DAY FROM DataUrodzStudenta) > 15 
            THEN 1 
            ELSE 0 END) AS WiekStudenta
FROM Studenci;


CREATE VIEW R19_plec_studentow
AS
SELECT IDStudenta, ImieStudenta, NazwiskoStudenta, 
   (CASE PlecStudenta 
      WHEN 'M' THEN 'Mezczyzna' 
      WHEN 'K' THEN 'Kobieta' 
      ELSE 'Nie określono' END) AS Plec
FROM Studenci;


CREATE VIEW R19_srednia_studentow_bez_0
AS
SELECT Studenci.IDStudenta, Studenci.ImieStudenta, Studenci.NazwiskoStudenta, 
   COUNT(SClasses.IDStudenta) AS LiczbaUkonczonychZaj, SUM(SClasses.PunktyEdukacyjne) AS SumaPktEduk, 
   CASE COUNT(SClasses.IDStudenta) 
      WHEN 0 THEN 0 
      ELSE ROUND(SUM(SClasses.PunktyEdukacyjne * CAST(SClasses.Ocena AS decimal(15,4))) / SUM(SClasses.PunktyEdukacyjne), 3) 
      END AS Srednia
FROM Studenci LEFT OUTER JOIN
    (SELECT Grafik_studenta.IDStudenta, Grafik_studenta.Ocena, Zajecia.PunktyEdukacyjne
     FROM   (Grafik_studenta INNER JOIN Status_zajec_studenta 
       ON Grafik_studenta.StatusZajec = Status_zajec_studenta.StatusZajec) 
     INNER JOIN Zajecia 
       ON Grafik_studenta.IDZajec = Zajecia.IDZajec
     WHERE  (Status_zajec_studenta.OpisStatusuZajec = 'Ukończono') 
            AND (Grafik_studenta.Ocena >= 67)) AS SClasses 
  ON Studenci.IDStudenta = SClasses.IDStudenta
GROUP BY Studenci.IDStudenta, Studenci.ImieStudenta, Studenci.NazwiskoStudenta;


CREATE VIEW R19_lista_mailingowa_studentow
AS
SELECT Concat((CASE WHEN PlecStudenta = 'M' THEN 'Pan ' 
                    WHEN StanCywilnyStudenta = 'S' THEN 'Panna/Pan ' 
                    ELSE 'Pani ' END), ImieStudenta, ' ', NazwiskoStudenta) AS WierszPersonaliow, 
   AdresStudenta AS WierszAdresu, Concat(MiastoStudenta, ', ', StanZamStudenta, '  ', KodPocztowyStudenta) AS WierszMiasta
FROM Studenci;


CREATE VIEW R19_stan_cywilny_studentow
AS
SELECT IDStudenta, ImieStudenta, NazwiskoStudenta, 
       (CASE StanCywilnyStudenta 
          WHEN 'M' THEN 'Mlzn' 
          WHEN 'S' THEN 'Smtn' 
          WHEN 'W' THEN 'Wdw' 
          WHEN 'R' THEN 'Rzwd' 
          ELSE 'Nie określono' END) AS StanCywilny
FROM Studenci;


CREATE VIEW R19_oceny_literowe_z_zajec_studentow
AS
SELECT  Studenci.IDStudenta, Studenci.ImieStudenta, Studenci.NazwiskoStudenta, Zajecia.IDZajec, 
Zajecia.DataRozpoczecia, Przedmioty.KodPrzedmiotu, 
                   Przedmioty.NazwaPrzedmiotu, Grafik_studenta.Ocena, 
                   (CASE WHEN Ocena BETWEEN 97 AND 100 THEN 'A+' 
                         WHEN Ocena BETWEEN 93 AND 96.99 THEN 'A' 
                         WHEN Ocena BETWEEN 90 AND 92.99 THEN 'A-' 
                         WHEN Ocena BETWEEN 87 AND 89.99 THEN 'B+' 
                         WHEN Ocena BETWEEN 83 AND 86.99 THEN 'B' 
                         WHEN Ocena BETWEEN 80 AND 82.99 THEN 'B-' 
                         WHEN Ocena BETWEEN 77 AND 79.99 THEN 'C+' 
                         WHEN Ocena BETWEEN 73 AND 76.99 THEN 'C' 
                         WHEN Ocena BETWEEN 70 AND 72.99 THEN 'C-' 
                         WHEN Ocena BETWEEN 67 AND 69.99 THEN 'D+' 
                         WHEN Ocena BETWEEN 63 AND 66.99 THEN 'R' 
                         WHEN Ocena BETWEEN 60 AND 62.99 THEN 'D-' 
                         ELSE 'K' END) AS OcenaLiterowa
FROM (((Studenci INNER JOIN Grafik_studenta 
        ON Studenci.IDStudenta = Grafik_studenta.IDStudenta) 
      INNER JOIN Zajecia 
        ON Grafik_studenta.IDZajec = Zajecia.IDZajec) 
      INNER JOIN Przedmioty 
        ON Zajecia.IDPrzedmiotu = Przedmioty.IDPrzedmiotu) 
      INNER JOIN Status_zajec_studenta 
        ON Grafik_studenta.StatusZajec = Status_zajec_studenta.StatusZajec
WHERE (Status_zajec_studenta.OpisStatusuZajec = 'Ukończono');


CREATE VIEW R20_kalendarz_zajec
AS 
SELECT ztblDniSemestru.NrSemestru, ztblDniSemestru.DataWSemestrze, Zajecia.GodzinaRozpoczecia, 
   ztblDniSemestru.DzienTygodnia, Przedmioty.KodPrzedmiotu, Przedmioty.NazwaPrzedmiotu, 
   Sale.KodBudynku, Sale.IDSali
FROM ztblDniSemestru CROSS JOIN (Przedmioty
  INNER JOIN Zajecia
    ON Przedmioty.IDPrzedmiotu=Zajecia.IDPrzedmiotu)
  INNER JOIN Sale
    ON Sale.IDSali=Zajecia.IDSali
WHERE Zajecia.NumerSemestru=ztblDniSemestru.NrSemestru AND 
   Zajecia.DataRozpoczecia<=ztblDniSemestru.DataWSemestrze 
AND 1 = 
  (CASE WHEN ztblDniSemestru.DzienTygodnia='Poniedziałek' And Zajecia.PlanNaPoniedzialek<>0 THEN 1 
        WHEN ztblDniSemestru.DzienTygodnia='Wtorek' And Zajecia.PlanNaWtorek<>0 THEN 1
        WHEN ztblDniSemestru.DzienTygodnia='Środa' And Zajecia.PlanNaSrode<>0 THEN 1 
        WHEN ztblDniSemestru.DzienTygodnia='Czwartek' And Zajecia.PlanNaCzwartek<>0 THEN 1 
        WHEN ztblDniSemestru.DzienTygodnia='Piątek' And Zajecia.PlanNaPiatek<>0 THEN 1 
        WHEN ztblDniSemestru.DzienTygodnia='Sobota' And Zajecia.PlanNaSobote<>0 THEN 1 
        ELSE 0 END)
ORDER BY ztblDniSemestru.NrSemestru, ztblDniSemestru.DataWSemestrze, Przedmioty.KodPrzedmiotu, 
  Sale.KodBudynku, Sale.IDSali, Zajecia.GodzinaRozpoczecia;


CREATE VIEW R20_studenci_jezyk_angielski_kwintyle
AS 
SELECT S1.IDPrzedmiotu, S1.ImieStudenta, S1.NazwiskoStudenta, S1.StatusZajec, S1.Ocena, 
  S1.IDDziedziny, S1.NazwaPrzedmiotu, S1.PozycjaWDziedzinie, StudCount.LiczbaStudentow, 
  (CASE WHEN PozycjaWDziedzinie<=0.2*LiczbaStudentow THEN 'Pierwszy' 
        WHEN PozycjaWDziedzinie<=0.4*LiczbaStudentow THEN 'Drugi' 
        WHEN PozycjaWDziedzinie<=0.6*LiczbaStudentow THEN 'Trzeci' 
        WHEN PozycjaWDziedzinie<=0.8*LiczbaStudentow THEN 'Czwarty' 
        ELSE 'Piąty' END) AS Kwintyl
FROM 
   (SELECT Przedmioty.IDPrzedmiotu, Studenci.ImieStudenta, Studenci.NazwiskoStudenta, 
        Grafik_studenta.StatusZajec, Grafik_studenta.Ocena, Przedmioty.IDDziedziny, 
        Przedmioty.NazwaPrzedmiotu, 
        (SELECT Count(*) 
         FROM (Zajecia INNER JOIN Grafik_studenta AS SS2    
           ON Zajecia.IDZajec = SS2.IDZajec)  
         INNER JOIN Przedmioty As S3  
           ON S3.IDPrzedmiotu = Zajecia.IDPrzedmiotu 
         WHERE S3.IDDziedziny = 'ANG'
           AND SS2.Ocena >= Grafik_studenta.Ocena) AS PozycjaWDziedzinie 
    FROM ((Przedmioty INNER JOIN Zajecia
      ON Przedmioty.IDPrzedmiotu = Zajecia.IDPrzedmiotu)
    INNER JOIN Grafik_studenta 
      ON Grafik_studenta.IDZajec = Zajecia.IDZajec)
    INNER JOIN Studenci
      ON Studenci.IDStudenta=Grafik_studenta.IDStudenta 
    WHERE Grafik_studenta.StatusZajec=2 And Przedmioty.IDDziedziny='ANG') AS S1 
CROSS JOIN 
   (SELECT Count(*) AS LiczbaStudentow 
    FROM (Zajecia AS C2 INNER JOIN Grafik_studenta AS SS3
      ON C2.IDZajec=SS3.IDZajec)
INNER JOIN Przedmioty AS S2
  ON S2.IDPrzedmiotu=C2.IDPrzedmiotu 
WHERE SS3.StatusZajec=2 And S2.IDDziedziny='ANG')  AS StudCount
ORDER BY S1.Ocena DESC;


CREATE VIEW R20_oceny_wykladowcow
AS 
SELECT OcenaPrac.IDPracownika, OcenaPrac.ImiePracownika, OcenaPrac.NazwiskoPracownika, OcenaPrac.Tytul, 
   OcenaPrac.SredniaOcena, ztblOcenyWykladowcow.OpisOcenyWykladowcy
FROM ztblOcenyWykladowcow CROSS JOIN 
  (SELECT Pracownicy.IDPracownika, Pracownicy.ImiePracownika, Pracownicy.NazwiskoPracownika, Wykladowcy.Tytul, 
      Avg(Przedmioty_wykladowcow.OcenaBieglosci) AS SredniaOcena 
   FROM (Pracownicy INNER JOIN Wykladowcy 
     ON Pracownicy.IDPracownika=Wykladowcy.IDPracownika)
   INNER JOIN Przedmioty_wykladowcow
    ON Wykladowcy.IDPracownika=Przedmioty_wykladowcow.IDPracownika 
   GROUP BY Pracownicy.IDPracownika, Pracownicy.ImiePracownika, Pracownicy.NazwiskoPracownika, Wykladowcy.Tytul)  AS OcenaPrac
WHERE OcenaPrac.SredniaOcena BETWEEN ztblOcenyWykladowcow.ProgDolnyOceny
AND ztblOcenyWykladowcow.ProgGornyOceny;


CREATE VIEW R20_zestawienie_plci_i_stanu_cywilnego_wg_regionu
AS 
SELECT Studenci.StanZamStudenta, Sum(Mezczyzna*Mlzn) AS Zonaty, Sum(Mezczyzna*Smtn) AS Singiel, 
   Sum(Mezczyzna*Wdw) AS Wdowiec, Sum(Mezczyzna*Rzwd) AS Rozwiedziony, 
   Sum(Kobieta*Mlzn) AS Zamezna, Sum(Kobieta*Smtn) AS Singielka, 
   Sum(Kobieta*Wdw) AS Wdowa, Sum(Kobieta*Rzwd) AS Rozwiedziona, 
   Sum((Mezczyzna*Mlzn)+(Mezczyzna*Smtn)+(Mezczyzna*Wdw)+(Mezczyzna*Rzwd)) AS LacznieMezczyzn, 
   Sum((Kobieta*Mlzn)+(Kobieta*Smtn)+(Kobieta*Wdw)+(Kobieta*Rzwd)) AS LacznieKobiet, 
   Sum(((Mezczyzna*Mlzn)+(Mezczyzna*Smtn)+(Mezczyzna*Wdw)+(Mezczyzna*Rzwd))+
     ((Kobieta*Mlzn)+(Kobieta*Smtn)+(Kobieta*Wdw)+(Kobieta*Rzwd))) AS Ogolem
FROM (Studenci
INNER JOIN ztblMacierzStanuCywilnego
  ON Studenci.StanCywilnyStudenta=ztblMacierzStanuCywilnego.StanCywilny)
INNER JOIN ztblMacierzPlci
  ON Studenci.PlecStudenta=ztblMacierzPlci.Plec
GROUP BY Studenci.StanZamStudenta;


CREATE VIEW R20_adresy_studentow_do_mailingu_z_pom_2
AS 
SELECT ' ' AS ImieStudenta, ' ' AS NazwiskoStudenta, ' ' AS AdresStudenta, ' ' AS MiastoStudenta, 
   ' ' AS StanZamStudenta, ' ' AS KodPocztowyStudenta
FROM ztblNumeryKolejne 
WHERE ztblNumeryKolejne.NrKolejny <= 2
UNION ALL SELECT Studenci.ImieStudenta, Studenci.NazwiskoStudenta, Studenci.AdresStudenta, 
   Studenci.MiastoStudenta, Studenci.StanZamStudenta, Studenci.KodPocztowyStudenta
FROM Studenci
ORDER BY KodPocztowyStudenta, NazwiskoStudenta;


CREATE VIEW R20_dodatkowe_zajecia_dla_studentow
AS 
SELECT Studenci.IDStudenta, Studenci.ImieStudenta, Studenci.NazwiskoStudenta, Przedmioty.IDPrzedmiotu, 
  Przedmioty.IDDziedziny, Przedmioty.KodPrzedmiotu, Przedmioty.NazwaPrzedmiotu, Przedmioty.Wymagania
FROM Studenci, Przedmioty
INNER JOIN Zajecia
  ON Przedmioty.IDPrzedmiotu=Zajecia.IDPrzedmiotu
WHERE Przedmioty.IDPrzedmiotu NOT IN  
  (SELECT Su2.IDPrzedmiotu  
   FROM (Przedmioty AS Su2 INNER JOIN Zajecia 
     ON Su2.IDPrzedmiotu = Zajecia.IDPrzedmiotu) 
   INNER JOIN Grafik_studenta 
     ON Zajecia.IDZajec = Grafik_studenta.IDZajec 
   WHERE Grafik_studenta.IDStudenta = Studenci.IDStudenta
     AND Grafik_studenta.StatusZajec IN (1,2))
ORDER BY Studenci.IDStudenta, Przedmioty.IDPrzedmiotu;


CREATE VIEW R20_oceny_literowe_z_zajec_studentow
AS 
SELECT Studenci.IDStudenta, Studenci.ImieStudenta, Studenci.NazwiskoStudenta, Zajecia.IDZajec, 
   Zajecia.DataRozpoczecia, Przedmioty.KodPrzedmiotu, Przedmioty.NazwaPrzedmiotu, 
   Grafik_studenta.Ocena, ztblOcenyLiterowe.OcenaLiterowa
FROM ztblOcenyLiterowe CROSS JOIN (((Studenci
INNER JOIN Grafik_studenta
  ON Studenci.IDStudenta=Grafik_studenta.IDStudenta)
INNER JOIN Zajecia
  ON Grafik_studenta.IDZajec=Zajecia.IDZajec)
INNER JOIN Przedmioty
  ON Zajecia.IDPrzedmiotu=Przedmioty.IDPrzedmiotu)
INNER JOIN Status_zajec_studenta
  ON Grafik_studenta.StatusZajec=Status_zajec_studenta.StatusZajec
WHERE (Status_zajec_studenta.OpisStatusuZajec='Ukończono') 
  AND (Grafik_studenta.Ocena Between ztblOcenyLiterowe.PunktowyProgDolny 
  AND ztblOcenyLiterowe.PunktowyProgGorny);

  
CREATE VIEW R21_budynek_sala_semestr_przedmiot_zliczanie_ROLLUP
AS
SELECT KodBudynku, IDSali, NrSemestru, KodPrzedmiotu,
  Count(*) AS LiczbaZajec
FROM R20_kalendarz_zajec
GROUP BY ROLLUP(KodBudynku, IDSali,  NrSemestru, KodPrzedmiotu);


CREATE VIEW R21_wydzial_tytul_zliczanie_ROLLUP
AS
SELECT D.NazwaWydzialu, F.Tytul, Count(*) AS Zajecia
FROM Pracownicy AS S
  INNER JOIN Wykladowcy AS F
    ON F.IDPracownika = S.IDPracownika 
  INNER JOIN Przedmioty_wykladowcow AS FS
    ON FS.IDPracownika = S.IDPracownika   
  INNER JOIN Przedmioty AS Su
    ON Su.IDPrzedmiotu = FS.IDPrzedmiotu   
  INNER JOIN Dziedziny AS C
    ON C.IDDziedziny = Su.IDDziedziny 
  INNER JOIN Wydzialy AS D
    ON D.IDWydzialu = C.IDWydzialu 
GROUP BY ROLLUP (D.NazwaWydzialu, F.Tytul);


CREATE VIEW R21_kierunek_statuszajec_zliczanie_GROUPING_SETS 
AS
SELECT M.Kierunek, SCS.OpisStatusuZajec, Count(*) AS Zajecia
FROM Kierunki AS M
  INNER JOIN Studenci AS S
    ON M.IDKierunku = S.KierunekStudiow 
  INNER JOIN Grafik_studenta AS SS
    ON  SS.IDStudenta = S.IDStudenta
  INNER JOIN Status_zajec_studenta AS SCS
    ON SCS.StatusZajec = SS.StatusZajec
  INNER JOIN Zajecia AS C
    ON C.IDZajec = SS.IDZajec
GROUP BY GROUPING SETS (M.Kierunek, SCS.OpisStatusuZajec, (M.Kierunek, SCS.OpisStatusuZajec));


CREATE VIEW R21_semestr_budynek_sala_przedmiot_zliczanie_GROUPING_SETS
AS
SELECT NrSemestru, KodBudynku, IDSali, KodPrzedmiotu, Count(*) AS LiczbaZajec
FROM R20_kalendarz_zajec
GROUP BY GROUPING SETS (NrSemestru, (KodBudynku, IDSali),  KodPrzedmiotu);


CREATE VIEW R21_studenci_stan_plec_cyw_liczba_CUBE_beznull
AS
SELECT (CASE WHEN GROUPING(StanZamStudenta) = 0 THEN StanZamStudenta ELSE 'Dowolny stan' END) AS StanZamieszkania, 
           (CASE WHEN GROUPING(PlecStudenta) = 0 THEN PlecStudenta ELSE 'Dowolna płeć' END) AS Plec,  
		   (CASE WHEN GROUPING(StanCywilnyStudenta) = 0 THEN StanCywilnyStudenta ELSE 'Dowolny stan cywilny' END) AS StanCywilny, 
			COUNT(*) AS Liczba
FROM    Studenci
GROUP BY CUBE (StanZamStudenta, PlecStudenta, StanCywilnyStudenta)
ORDER BY StanZamieszkania, Plec, StanCywilny;


CREATE VIEW R21_studenci_stan_plec_cyw_liczba_CUBE_kol1
AS
SELECT StanZamStudenta, PlecStudenta, StanCywilnyStudenta, Count(*) AS Liczba
FROM Studenci
GROUP BY CUBE (StanZamStudenta, PlecStudenta, StanCywilnyStudenta);


CREATE VIEW R21_studenci_stan_plec_cyw_liczba_CUBE_kol2
AS
SELECT StanCywilnyStudenta, PlecStudenta, StanZamStudenta, Count(*) AS Liczba
FROM Studenci
GROUP BY CUBE (StanCywilnyStudenta, PlecStudenta, StanZamStudenta);


CREATE VIEW R21_studenci_stan_plec_cyw_liczba_CUBE_czesciowo 
AS
SELECT StanZamStudenta, PlecStudenta, StanCywilnyStudenta, COUNT(*) AS Liczba
FROM     Studenci
GROUP BY StanZamStudenta, CUBE (PlecStudenta, StanCywilnyStudenta)
ORDER BY StanZamStudenta, PlecStudenta, StanCywilnyStudenta;


CREATE VIEW R21_studenci_stan_plec_cyw_liczba_GROUPBY
AS
SELECT StanZamStudenta, PlecStudenta, StanCywilnyStudenta, 
  Count(*) AS Liczba
FROM Studenci
GROUP BY StanZamStudenta, PlecStudenta, StanCywilnyStudenta;


CREATE VIEW R21_studenci_stan_plec_cyw_liczba_GROUPBY_UNION
AS
SELECT NULL AS StanZamStudenta, NULL AS PlecStudenta, StanCywilnyStudenta, Count(*) AS Liczba
FROM Studenci
GROUP BY StanCywilnyStudenta
UNION
SELECT NULL, PlecStudenta, NULL, Count(*) 
FROM Studenci
GROUP BY PlecStudenta
UNION
SELECT StanZamStudenta, NULL, NULL, Count(*) 
FROM Studenci
GROUP BY StanZamStudenta;


CREATE VIEW R21_studenci_stan_plec_cyw_liczba_GROUPING_SETS
AS
SELECT StanZamStudenta, PlecStudenta, StanCywilnyStudenta, Count(*) AS Liczba
FROM Studenci
GROUP BY GROUPING SETS (StanZamStudenta, PlecStudenta, StanCywilnyStudenta);


CREATE VIEW R21_studenci_stan_plec_cyw_liczba_GROUPING_SETS_1
AS
SELECT StanZamStudenta, PlecStudenta, StanCywilnyStudenta, Count(*) AS Liczba
FROM Studenci
GROUP BY GROUPING SETS (StanZamStudenta, (StanZamStudenta, PlecStudenta), (StanZamStudenta, StanCywilnyStudenta));


CREATE VIEW R21_studenci_stan_plec_cyw_liczba_GROUPING_SETS_2
AS
SELECT StanZamStudenta, PlecStudenta, StanCywilnyStudenta, Count(*) AS Liczba
FROM Studenci
GROUP BY GROUPING SETS (StanZamStudenta, (PlecStudenta, StanCywilnyStudenta));


CREATE VIEW R21_studenci_stan_plec_cyw_liczba_ROLLUP_kol1
AS
SELECT StanZamStudenta, PlecStudenta, StanCywilnyStudenta, Count(*) AS Liczba
FROM Studenci
GROUP BY ROLLUP (StanZamStudenta, PlecStudenta, StanCywilnyStudenta);


CREATE VIEW R21_studenci_stan_plec_cyw_liczba_ROLLUP_beznull
AS
SELECT     (CASE WHEN GROUPING(StanZamStudenta) = 0 THEN StanZamStudenta ELSE 'Dowolny stan' END) AS StanZamieszkania, 
           (CASE WHEN GROUPING(PlecStudenta) = 0 THEN PlecStudenta ELSE 'Dowolna płeć' END) AS Plec,  
		   (CASE WHEN GROUPING(StanCywilnyStudenta) = 0 THEN StanCywilnyStudenta ELSE 'Dowolny stan cywilny' END) AS StanCywilny, 
			COUNT(*) AS Liczba
FROM       Studenci
GROUP BY ROLLUP (StanZamStudenta, PlecStudenta, StanCywilnyStudenta);


CREATE VIEW R21_studenci_stan_plec_cyw_liczba_ROLLUP_kol2
AS
SELECT StanCywilnyStudenta, PlecStudenta, StanZamStudenta, Count(*) AS Liczba
FROM Studenci
GROUP BY ROLLUP (StanCywilnyStudenta, PlecStudenta, StanZamStudenta);


CREATE VIEW R21_studenci_stan_plec_cyw_liczba_ROLLUP_kol3
AS
SELECT StanZamStudenta, PlecStudenta, StanCywilnyStudenta, Count(*) AS Liczba
FROM Studenci
GROUP BY ROLLUP (StanCywilnyStudenta, PlecStudenta, StanZamStudenta);


CREATE VIEW R21_studenci_stan_plec_cyw_liczba_ROLLUP_czesciowo
AS
SELECT StanZamStudenta, PlecStudenta, StanCywilnyStudenta, Count(*) AS Liczba
FROM Studenci
GROUP BY StanZamStudenta, ROLLUP (PlecStudenta, StanCywilnyStudenta);


CREATE VIEW R22_studenci_angielski_kwintyle 
AS
SELECT Su.IDPrzedmiotu, St.ImieStudenta, 
  St.NazwiskoStudenta, Su.NazwaPrzedmiotu, SS.Ocena, 
  RANK() OVER (ORDER BY SS.Ocena DESC) AS Pozycja, 
  NTILE(5) OVER(ORDER BY SS.Ocena DESC) AS Kwintyl  
FROM Studenci AS St
  INNER JOIN Grafik_studenta AS SS 
    ON SS.IDStudenta = St.IDStudenta
  INNER JOIN Zajecia AS C
    ON C.IDZajec = SS.IDZajec 
  INNER JOIN Przedmioty AS Su
    ON Su.IDPrzedmiotu = C.IDPrzedmiotu   
WHERE SS.StatusZajec = 2 
  AND Su.IDDziedziny = 'ANG';


CREATE VIEW R22_ranking_studentow_angielski 
AS
SELECT Su.IDPrzedmiotu, St.ImieStudenta, 
  St.NazwiskoStudenta, Su.NazwaPrzedmiotu,
  SS.Ocena, 
  RANK() OVER ( 
    ORDER BY SS.Ocena DESC
  ) AS Pozycja 
FROM Studenci AS St
  INNER JOIN Grafik_studenta AS SS 
    ON SS.IDStudenta = St.IDStudenta
  INNER JOIN Zajecia AS C
    ON C.IDZajec = SS.IDZajec 
  INNER JOIN Przedmioty AS Su
    ON Su.IDPrzedmiotu = C.IDPrzedmiotu   
WHERE SS.StatusZajec = 2 
  AND Su.IDDziedziny = 'ANG';

  
CREATE VIEW R22_oceny_min_maks
AS
SELECT St.ImieStudenta || ' ' || St.NazwiskoStudenta AS Student,
  Su.NazwaPrzedmiotu,
  SS.Ocena,
  AVG(SS.Ocena) OVER (
    PARTITION BY St.NazwiskoStudenta, St.ImieStudenta
  ) AS Srednia,
  MIN(SS.Ocena) OVER (
    PARTITION BY St.NazwiskoStudenta, St.ImieStudenta
	ORDER BY St.NazwiskoStudenta, St.ImieStudenta
	ROWS BETWEEN 1 PRECEDING AND 1 FOLLOWING
  ) AS Minimum,
  MAX(SS.Ocena) OVER (
    PARTITION BY St.NazwiskoStudenta, St.ImieStudenta
	ORDER BY St.NazwiskoStudenta, St.ImieStudenta
	ROWS BETWEEN 1 PRECEDING AND 1 FOLLOWING
  ) AS Maksimum
FROM Studenci AS St
  INNER JOIN Grafik_studenta AS SS
    ON SS.IDStudenta = St.IDStudenta
  INNER JOIN Zajecia AS C
    ON C.IDZajec = SS.IDZajec
  INNER JOIN Przedmioty AS Su
    ON Su.IDPrzedmiotu = C.IDPrzedmiotu
WHERE SS.StatusZajec = 2;


CREATE VIEW R22_ranking_wykladowcow_wg_prowadzonych_zajec
AS
SELECT Pracownicy.IDPracownika, 
  Pracownicy.ImiePracownika || ' ' || Pracownicy.NazwiskoPracownika AS Pracownicy,
  COUNT(*) AS LiczbaZajec, 
  RANK() OVER (
    ORDER BY COUNT(*) DESC
  ) AS Pozycja 
FROM Pracownicy 
  INNER JOIN Wykladowcy 
    ON Wykladowcy.IDPracownika = Pracownicy.IDPracownika
  INNER JOIN Zajecia_wykladowcow
    ON Zajecia_wykladowcow.IDPracownika = Wykladowcy.IDPracownika
GROUP BY Pracownicy.IDPracownika, Pracownicy.ImiePracownika, Pracownicy.NazwiskoPracownika;


CREATE VIEW R22_ranking_stazu_pracy
AS
SELECT IDPracownika, ImiePracownika || ' ' || NazwiskoPracownika AS Pracownik, 
   EXTRACT(YEAR FROM CAST('2018-01-01' As Date)) - 
      EXTRACT(YEAR FROM DataZatrudnienia) - 
      (CASE WHEN EXTRACT(MONTH FROM DataZatrudnienia) < 10 
            THEN 0 
            WHEN EXTRACT(MONTH FROM DataZatrudnienia) > 10 
            THEN 1 
            WHEN EXTRACT(DAY FROM DataZatrudnienia) > 1 
            THEN 1 
            ELSE 0 END) AS StazPracy,
  DENSE_RANK() OVER (ORDER BY EXTRACT(YEAR FROM CAST('2018-01-01' As Date)) - 
      EXTRACT(YEAR FROM DataZatrudnienia) - 
      (CASE WHEN EXTRACT(MONTH FROM DataZatrudnienia) < 10 
            THEN 0 
            WHEN EXTRACT(MONTH FROM DataZatrudnienia) > 10 
            THEN 1 
            WHEN EXTRACT(DAY FROM DataZatrudnienia) > 1 
            THEN 1 
            ELSE 0 END) DESC
  ) AS Ranking
FROM Pracownicy;


CREATE VIEW R22_studenci_srednia_grupy
AS
SELECT Studenci.IDStudenta, 
  Studenci.ImieStudenta || ' ' || Studenci.NazwiskoStudenta AS Student,
  AVG(Grafik_studenta.Ocena) AS SredniaOcena, 
  NTILE(3) OVER (
    ORDER BY AVG(Grafik_studenta.Ocena) DESC
  ) AS Pozycja 
FROM Studenci  
  INNER JOIN Grafik_studenta
    ON Grafik_studenta.IDStudenta = Studenci.IDStudenta
WHERE Grafik_studenta.StatusZajec = 2
GROUP BY Studenci.IDStudenta, Studenci.ImieStudenta, Studenci.NazwiskoStudenta;


CREATE VIEW R22_ranking_studentow_wg_ukonczonych_zajec
AS
SELECT Studenci.IDStudenta, 
  Studenci.ImieStudenta || ' ' || Studenci.NazwiskoStudenta AS Student,
  COUNT(*) AS LiczbaZajec, 
  RANK() OVER (
    ORDER BY COUNT(*) DESC
  ) AS Pozycja 
FROM Studenci  
  INNER JOIN Grafik_studenta
    ON Grafik_studenta.IDStudenta = Studenci.IDStudenta
WHERE Grafik_studenta.StatusZajec = 2
GROUP BY Studenci.IDStudenta, Studenci.ImieStudenta, Studenci.NazwiskoStudenta;


CREATE VIEW R22_najwyzsze_oceny
AS
SELECT DISTINCT Przedmioty.IDDziedziny,
  Przedmioty.KodPrzedmiotu, Przedmioty.NazwaPrzedmiotu,
  MAX(Grafik_studenta.Ocena) OVER (
    PARTITION BY Przedmioty.IDPrzedmiotu
  ) AS MaksZPrzedmiotu, 
  MAX(Grafik_studenta.Ocena) OVER (
    PARTITION BY Przedmioty.IDDziedziny
  ) AS MaksZDziedziny,
  MAX(Grafik_studenta.Ocena) OVER (
  ) AS MaksOgolem
FROM Przedmioty 
  INNER JOIN Zajecia
    ON Zajecia.IDPrzedmiotu = Przedmioty.IDPrzedmiotu
  INNER JOIN Grafik_studenta 
    ON Grafik_studenta.IDZajec = Zajecia.IDZajec
WHERE Grafik_studenta.StatusZajec = 2;

